<?php
namespace MarvyElementor\animation;

if( !defined( 'ABSPATH' ) ) exit;
use Elementor\Controls_Manager;

class MarvyFluidAnimation {

    public function __construct(){
        add_action('elementor/frontend/section/before_render', array($this, 'before_render'), 1);
        add_action('elementor/element/section/section_layout/after_section_end',array($this,'register_controls'), 1 );
    }

    public function register_controls( $element )
    {
        $element->start_controls_section('marvy_fluid_animation_section',
            [
                'label' => __('<div style="float: right"><img src="'.plugin_dir_url(__DIR__).'assets/images/logo.png" height="15px" width="15px" style="flot:left;"></div> Fluid Animation', 'marvy-lang'),
                'tab' => Controls_Manager::TAB_LAYOUT
            ]
        );

        $element->add_control('marvy_enable_fluid_animation',
            [
                'label' => esc_html__( 'Enable Fluid', 'marvy-lang'),
                'type'  => Controls_Manager::SWITCHER
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_background_color',
            [
                'label' => esc_html__('Background Color', 'marvy-lang'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_resolution',
            [
                'label' => esc_html__('Sim Resolution', 'marvy-lang'),
                'type' => Controls_Manager::SELECT,
                'default' => '128',
                'options' => [
                    '32' => esc_html__('32', 'marvy-lang'),
                    '64' => esc_html__('64', 'marvy-lang'),
                    '128' => esc_html__('128', 'marvy-lang'),
                    '256' => esc_html__('256', 'marvy-lang')
                ],
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_quality',
            [
                'label' => esc_html__('Quality', 'marvy-lang'),
                'type' => Controls_Manager::SELECT,
                'default' => '512',
                'options' => [
                    '1024' => esc_html__('High', 'marvy-lang'),
                    '512' => esc_html__('Medium', 'marvy-lang'),
                    '256' => esc_html__('Low', 'marvy-lang'),
                    '128' => esc_html__('Very Low', 'marvy-lang')
                ],
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_density',
            [
                'label' => esc_html__('Density', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.95,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_pressure',
            [
                'label' => esc_html__('Pressure', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.8,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_velocity_diffusion',
            [
                'label' => esc_html__('Velocity Diffusion', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.95,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_vorticity',
            [
                'label' => esc_html__('Vorticity', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 30,
                'min' => 0,
                'max' => 50,
                'step' => 5,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_splat_radius',
            [
                'label' => esc_html__('Splat Radius', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.25,
                'min' => 0.01,
                'max' => 2,
                'step' => 0.10,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_bloom',
            [
                'label' => esc_html__('Bloom', 'marvy-lang'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'marvy-lang'),
                'label_off' => esc_html__('No', 'marvy-lang'),
                'default' => 'yes',
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_intensity',
            [
                'label' => esc_html__('Bloom Intensity', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.8,
                'min' => 0.10,
                'max' => 2,
                'step' => 0.10,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes',
                    'marvy_fluid_animation_bloom' => 'yes'
                ]
            ]
        );

        $element->add_control(
            'marvy_fluid_animation_threshold',
            [
                'label' => esc_html__('Threshold', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.6,
                'min' => 0,
                'max' => 1,
                'step' => 0.10,
                'condition' => [
                    'marvy_enable_fluid_animation' => 'yes',
                    'marvy_fluid_animation_bloom' => 'yes'
                ]
            ]
        );

        $element->end_controls_section();
    }

    public function before_render($element) {
        $settings = $element->get_settings();
        if ($settings['marvy_enable_fluid_animation'] === 'yes') {
            $element->add_render_attribute(
                '_wrapper',
                [
                    'data-marvy_enable_fluid_animation' => 'true',
                    'data-marvy_fluid_animation_resolution' => $settings['marvy_fluid_animation_resolution'],
                    'data-marvy_fluid_animation_quality' => $settings['marvy_fluid_animation_quality'],
                    'data-marvy_fluid_animation_density' => $settings['marvy_fluid_animation_density'],
                    'data-marvy_fluid_animation_pressure' => $settings['marvy_fluid_animation_pressure'],
                    'data-marvy_fluid_animation_velocity_diffusion' => $settings['marvy_fluid_animation_velocity_diffusion'],
                    'data-marvy_fluid_animation_vorticity' => $settings['marvy_fluid_animation_vorticity'],
                    'data-marvy_fluid_animation_splat_radius' => $settings['marvy_fluid_animation_splat_radius'],
                    'data-marvy_fluid_animation_bloom' => $settings['marvy_fluid_animation_bloom'],
                    'data-marvy_fluid_animation_intensity' => $settings['marvy_fluid_animation_intensity'],
                    'data-marvy_fluid_animation_threshold' => $settings['marvy_fluid_animation_threshold'],
                    'data-marvy_fluid_animation_background_color' => $settings['marvy_fluid_animation_background_color']
                ]
            );
        } else {
            $element->add_render_attribute('_wrapper', 'data-marvy_enable_fluid_animation', 'false');
        }
    }
}
